const char HTML[] PROGMEM = R"=====(
<!DOCTYPE html>
<html>
 <head>
  <title>Light Controller</title>
  <meta name='viewport' content='width=device-width, initial-scale=1'>
  <meta charset='UTF-8'>
  <link rel='stylesheet' href='https://marcelv.net/client/w3.css'>
  <script type='text/javascript' src='https://marcelv.net/client/jquery-3.5.1.min.js'></script>
  <link rel='icon' type='image/png' href='https://marcelv/net/favicon.png'/>
  <link rel='stylesheet' href='https://marcelv.net/client/3d.css'>
  <style>
   .m2,.main { width:800px;}
   .main {width:800px}
   .mainwrapper{min-height:0;}
   .w3-button{width:140px;margin-right:8px;margin-left:8px}
  </style>
 </head>
 <body>
  <div class='m m2'>
   <div class='dubbel'>&nbsp;</div>
   <div id='h1'>
    <a href='/' title='Licht-Controller'>
     <img src='https://marcelv.net/pix/logo.png' class='w3-image' />
     <div class='logo'><span class='rood1'>Licht</span><span class='donkergrijs'>-</span><span class='oranje'>controller</span>
      <div class='logo2'>Met WOPR-technologie</div>
     </div>
    </a>
    <div class='w3-right ikonen'></div>
   </div>

   <div class='bortop'>&nbsp;</div>

   <div class='mainwrapper'>
    <div class='main' style='padding:32px;text-align:center'>
     <span id='S' class="w3-circle w3-grey w3-border w3-border-black ">&nbsp;&nbsp;&nbsp;&nbsp;</span>
     <button class="w3-button w3-green w3-round" onclick="Xaja('startLEDStrip','S')">LED-Strip aan</button>
     <button class="w3-button w3-red w3-round" onclick="Xaja('stopLEDStrip','S')">LED-Strip uit</button>
     <br><br>
     <span id="L1" class="w3-circle w3-grey w3-border w3-border-black ">&nbsp;&nbsp;&nbsp;&nbsp;</span>
     <button class="w3-button w3-green w3-round" onclick="Xaja('startLamp1','L1')">Lampje 1 aan</button>
     <button class="w3-button w3-red w3-round" onclick="Xaja('stopLamp1','L1')">Lampje 1 uit</button>
     <br><br>
     <span id="L2" class="w3-circle w3-grey w3-border w3-border-black ">&nbsp;&nbsp;&nbsp;&nbsp;</span>
     <button class="w3-button w3-green w3-round" onclick="Xaja('startLamp2','L2')">Lampje 2 aan</button>
     <button class="w3-button w3-red w3-round" onclick="Xaja('stopLamp2','L2')">Lampje 2 uit</button>
     <br>
    </div>
   </div>

   <div class='bortop'>&nbsp;</div>

   <div style="font-size:0.7em;text-align:center;border-left:1px solid #B0B0B0;border-right:1px solid #B0B0B0;padding:16px;padding-top:24px;">
    <img src="https://marcelv.net/pub/webserver.jpg" class="w3-round w3-image" style="width:25%;height:180px">
    &nbsp;&nbsp;&nbsp;
    <img src="https://marcelv.net/pub/webserverrelais.jpg" class="w3-round w3-image" style="width:25%;height:180px">
    <div style='padding-top:16px'>
    De webserver waar deze pagina op draait:
    <br>
    een D1 Mini met 140kB RAM
    </div>
   </div>

   <div class='bortop'>&nbsp;</div>

   <div style="font-size:0.9em;text-align:center;border-left:1px solid #B0B0B0;border-right:1px solid #B0B0B0;padding:16px;padding-top:24px;">
    Toegang voor text-based browsers:<br>
    <a href="/startLEDStrip">LED-Strip aan</a>&nbsp;&nbsp;&nbsp;<a href="/stopLEDStrip">LED-Strip uit</a><br>
    <a href="/startLamp1">Lampje 1 aan</a>&nbsp;&nbsp;&nbsp;<a href="/stopLamp1">Lampje 1 uit</a><br>
    <a href="/startLamp2">Lampje 2 aan</a>&nbsp;&nbsp;&nbsp;<a href="/stopLamp2">Lampje 2 uit</a><br>
   </div>

   <div class='dubbel'>&nbsp;</div>

   <div class='footer donkergrijs'>
    <div class='w3-left'>(C) 2023 marcelv</div>
   </div>

  </div><!-- m -->

  <script>
   Xaja('getLEDStrip','S');
   Xaja('getLamp1','L1');
   Xaja('getLamp2','L2');
   async function Xaja(url,elemId) {
    const response = await fetch('/'+url);
    if(!response.ok) {
     alert("Mislukt!");
    }
    const r = await response.text();
    var elem=document.querySelectorAll('#'+elemId)[0];
    elem.classList.remove("w3-lime");
    elem.classList.remove("w3-grey");
    if(r=="0") elem.classList.add("w3-grey");
    else elem.classList.add("w3-lime");
   }
  </script>
 </body>
</html>

)=====";
