#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>
#include "html.h"

#define WSSID "Wifi SSID"
#define WPASS "Wifi Wachtwoord"

#define LEDSTRIP  D0
#define LAMP1     D1
#define LAMP2     D2

#define AAN LOW
#define UIT HIGH

bool StripAan=false,Lamp1Aan=false,Lamp2Aan=false;

IPAddress IP(192,168,0,108); // Vast IP-adres 192.168.0.108
IPAddress Router(192,168,0,1);
IPAddress Subnet(255,255,255,0);

ESP8266WebServer Webserver(80);

void setup() {
 Serial.begin(115200);
 Serial.println();
 pinMode(LEDSTRIP,OUTPUT);digitalWrite(LEDSTRIP,UIT);
 pinMode(LAMP1,OUTPUT);digitalWrite(LAMP1,UIT);
 pinMode(LAMP2,OUTPUT);digitalWrite(LAMP2,UIT);

 WiFi.mode(WIFI_STA);
 WiFi.begin(WSSID, WPASS);
 if(!WiFi.config(IP, Router, Subnet)) Serial.println("STA Failed to configure");
 while(WiFi.status()!=WL_CONNECTED) {
  delay(500);
  Serial.print(".");
 }
 Serial.println("");
 Serial.println(WiFi.localIP());
 
 Webserver.on("/", webRoot);
 Webserver.on("/stopLEDStrip", webStopLEDStrip);
 Webserver.on("/stopLamp1", webStopLamp1);
 Webserver.on("/stopLamp2", webStopLamp2);

 Webserver.on("/startLEDStrip", webStartLEDStrip);
 Webserver.on("/startLamp1", webStartLamp1);
 Webserver.on("/startLamp2", webStartLamp2);

 Webserver.on("/getLEDStrip", webGetLEDStrip);
 Webserver.on("/getLamp1", webGetLamp1);
 Webserver.on("/getLamp2", webGetLamp2);
 
 Webserver.begin();
 Serial.println("Webserver gestart");
}

void webRoot() { 
 String s(HTML);
 //s.replace("$KLEURSTRIP$",StripAan? "w3-grey" : "w3-line";
 Webserver.send(200,"text/html",s);
}

void webGetLEDStrip() {ShowStatus(StripAan);}
void webGetLamp1() {ShowStatus(Lamp1Aan);}
void webGetLamp2() {ShowStatus(Lamp2Aan);}

void webStopLEDStrip() { Stop("LED-Strip",LEDSTRIP);StripAan=false;}
void webStopLamp1() { Stop("Lamp 1",LAMP1);Lamp1Aan=false;}
void webStopLamp2() { Stop("Lamp 2",LAMP2);Lamp2Aan=false;}

void webStartLEDStrip() { Start("LED-Strip",LEDSTRIP);StripAan=true;}
void webStartLamp1() { Start("Lamp 1",LAMP1);Lamp1Aan=true;}
void webStartLamp2() { Start("Lamp 2",LAMP2);Lamp2Aan=true;}

void loop() {
 Webserver.handleClient(); 
}

void ShowStatus(bool IsAan) {
 Webserver.send(200,"text/html",IsAan? "1" : "0"); 
}

void Start(String PrinterNaam,int GPIO) {
 digitalWrite(GPIO,AAN);
 Serial.println(PrinterNaam+String(" gestart!"));
 Webserver.send(200,"text/html","1"); 
}

void Stop(String PrinterNaam,int GPIO) {
 digitalWrite(GPIO,UIT);
 Serial.println(PrinterNaam+String(" gestopt!"));
 Webserver.send(200,"text/html","0"); 
}
